# TTS Android SDK Development Documentation

**Add AAR Dependency**

Place `android-tts-sdk-release-V1.0.0.0.aar` into the `libs` directory of your project. Modify the `build.gradle` file of the `app` module to add the aar file and okhttp as dependencies.

```java
implementation fileTree(dir:"libs",include:["*.jar","*.aar"])
implementation'com.squareup.okhttp3:okhttp:4.9.0'
 ```

#### Add Application Permissions

Modify the AndroidManifest.xml file

 ```xml
<!--Network permission-->
<uses-permission android:name="android.permission.INTERNET" />
```

## Usage Steps / Sample Code

### 1. Get an Instance

#### ⑴ Create a Synthesis Class

```java
     Tts tts=Tts.getInstance(this,((code,msg)->{
        if("00000".equals(code)){
        System.out.println("Success");
        }else{
        Toast.makeText(this,msg,Toast.LENGTH_SHORT).show();
        }
      }));  
```

#### ⑵ Set Callback

(1) Callback Parameter Description  
|Name|Type|Description|Return Parameter|
|-------|-------|-------|-------|
|onStart|Function|Callback method when engine connection starts|String type, current task ID|
|onWarning|Function|Callback method for engine warning messages|Task ID and Errors type status code|
|onError|Function|Callback method for engine error messages|Task ID and Errors type status code|
|onPlayStart|Function|Callback method when playback starts|None|
|onPlayFinish|Function|Callback method when synthesis ends|None|
|onGetAudio|Function|Callback method for synthesized audio data|byte[] type audio data|
|onSynthesisTimestamp|Function|Callback method for timestamp and phoneme data|JsonObject|
|onStop|Function|Callback method when playback ends|None|

(2) Callback Example

```java
tts.setListener(new Tts.Listener(){
@Override
public void onStart(String taskId){}

@Override
public void onStop(){}

@Override
public void onError(String taskId,ErrorCodes.ErrorCode err){}

@Override
public void onGetAudio(byte[]data){}

@Override
public void onPlayStart(){}

@Override
public void onPlayFinish(){}

@Override
public void onSynthesisTimestamp(JsonObject payload){}

@Override
public void onWarning(String taskId,ErrorCodes.ErrorCode err){}

        });
```

### 3. Parameter Settings


| Name             | Type    | Required | Discription                                                  | Default Value                                        |
| ---------------- | ------- | -------- | ------------------------------------------------------------ | ---------------------------------------------------- |
| text             | String  | Yes      | Text to be synthesized, length limit: 1024 bytes (UTF-8 encoding) | No                                                   |
| lang_type        | String  | Yes      | Language option, refer to [Development Guide - Language and Voice Support](https://kimi.moonshot.cn/chat/cv7tudtjqedf3re0diag#/help?url=tts/guidance.md) | No                                                   |
| voice            | String  | No       | VoiceID, refer to [Development Guide - Language and Voice Support](https://kimi.moonshot.cn/chat/cv7tudtjqedf3re0diag#/help?url=tts/guidance.md) | Japanese: Yuko<br>English：Julie<br>Chinese：Xiaohui |
| sample_rate      | Integer | No       | Audio sample rate, options are 8000, 16000, 24000            | 24000                                                |
| format           | String  | No       | Audio encode format, wav / pcm  / mp3, <br/>note: wav does not support streaming | pcm                                                  |
| speech_rate      | Float   | No       | Speech rate, parameter range [0.2, 3], usually retaining one decimal place is sufficient | 1                                                    |
| volume           | Float   | No       | Volume, parameter range [0.1, 3], usually retaining one decimal place is sufficient | 1                                                    |
| pitch_rate       | Float   | No       | Speech rate, parameter range [0.1, 3], usually retaining one decimal place is sufficient | 1                                                    |
| emotion          | String  | No       | Emotion/style, refer to [Development Guide - Language and Voice Support](https://kimi.moonshot.cn/chat/cv7tudtjqedf3re0diag#/help?url=tts/guidance.md) | No                                                   |
| silence_duration | Integer | No       | Silence duration at the end of the sentence, in ms           | 125                                                  |
| enable_timestamp | Boolean | No       | Timestamp related, when passed as true, it indicates enabling, and the original text's timestamps can be returned. Note: multiple consecutive punctuation or spaces in the original text will still be processed, but this will not affect the continuity of the timestamps | false                                                |

```java
   Tts.Params params=tts.getParams();
        params.setText(text);
        params.setSampleRate(24000);
        params.setFormat("pcm");
        params.setLang("zh-cmn-Hans-CN");
```

### 4. Start / Stop Synthesis

```java
tts.start();
tts.stop(); 
```